// Node.js로 PNG 아이콘 생성 (임시 placeholder)
// 실제 사용 시에는 디자인 툴에서 제작한 아이콘으로 교체 권장

const fs = require('fs');

// 간단한 SVG 아이콘 생성
function createSVG(size) {
  return `<?xml version="1.0" encoding="UTF-8"?>
<svg width="${size}" height="${size}" viewBox="0 0 ${size} ${size}" xmlns="http://www.w3.org/2000/svg">
  <defs>
    <linearGradient id="grad" x1="0%" y1="0%" x2="100%" y2="100%">
      <stop offset="0%" style="stop-color:#3B82F6;stop-opacity:1" />
      <stop offset="100%" style="stop-color:#8B5CF6;stop-opacity:1" />
    </linearGradient>
  </defs>
  <!-- 배경 원 -->
  <circle cx="${size/2}" cy="${size/2}" r="${size*0.4}" fill="url(#grad)"/>
  <!-- 주식 차트 라인 -->
  <polyline points="${size*0.25},${size*0.65} ${size*0.45},${size*0.5} ${size*0.7},${size*0.3}" 
    stroke="white" stroke-width="${size*0.08}" fill="none" stroke-linecap="round" stroke-linejoin="round"/>
  <!-- 뇌 상징 곡선 -->
  <path d="M ${size*0.35} ${size*0.35} Q ${size*0.5} ${size*0.25} ${size*0.65} ${size*0.35}" 
    stroke="white" stroke-width="${size*0.06}" fill="none" stroke-linecap="round"/>
</svg>`;
}

// SVG 파일 저장
[16, 48, 128].forEach(size => {
  fs.writeFileSync(`icon${size}.svg`, createSVG(size));
  console.log(`icon${size}.svg 생성 완료`);
});

console.log('\nSVG 아이콘이 생성되었습니다.');
console.log('PNG 변환이 필요하면 다음 명령어를 실행하세요:');
console.log('  npm install -g sharp-cli');
console.log('  sharp -i icon16.svg -o icon16.png');
console.log('  sharp -i icon48.svg -o icon48.png');
console.log('  sharp -i icon128.svg -o icon128.png');
